<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Models\CarOwner;
use App\Models\CarWashOwner;
use App\Models\WashDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;
use Carbon\Carbon;
use DB;

class AdminController extends Controller
{


    public function index(Request $request)
    {

        $data['page_title'] = "Dashboard";
        $data['page_sub_title'] = "Statistics Overview";
        $data['home_url'] = route('admin.dashboard');
        View::share('data', $data);

        $data['cards'] = $this->card_data();
        // dd($data);
        return view('admin.dashboard', $data);
    }

    protected function card_data()
    {
        $cwo_count = CarWashOwner::count();
        $co_count = CarOwner::count();
        $total_revenue = WashDetail::select(DB::raw('SUM(amount) as total_revenue'))->get();
        $today = date("Y-m-d"); 
        // $thirty_days_ago = date('Y-m-d', strtotime('-30 days', strtotime($today)));
        // $year_ago = date('Y-m-d', strtotime('-365 days', strtotime($today)));
        $total_car_washed_today = WashDetail::whereDate('date_washed', $today)->count();
        $total_car_washed_this_month = WashDetail::whereYear('date_washed', Carbon::now()->year)->whereMonth('date_washed', Carbon::now()->month)->count();
        $total_car_washed_this_year = WashDetail::whereYear('date_washed', Carbon::now()->year)->count();
        // echo "<pre>";print_r($year_ago);exit;

        $card_data = [
            [
                'title' => 'Car Wash Owners',
                'count' => $cwo_count,
                'icon' => 'icon-truck',
                'color' => '#1e89c8'
            ],
            [
                'title' => 'Car Owners',
                'count' => $co_count,
                'icon' => 'icon-users',
                'color' => '#e58e95'
            ],
            [
                'title'=>'R Total Revenue Generated',
                'count' => $total_revenue[0]['total_revenue'],
                'icon'=>'icon-users',
                'color' => '#90afd0'

            ],
            [
                'title'=>'Total Cars Washed Today',
                'count' => $total_car_washed_today,
                'icon'=>'icon-truck',
                'color' => '#df3657'
            ],
            [
                'title'=>'Total Cars Washed This Month',
                'count' => $total_car_washed_this_month,
                'icon'=>'icon-truck',
                'color' => '#ffa730'
            ],
            [
                'title'=>'Total Cars Washed This Year',
                'count' => $total_car_washed_this_year,
                'icon'=>'icon-truck',
                'color' => '#5dbaac'
            ],

        ];

        return $card_data;
    }
}
