<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
// use App\Services\CarWashClientService;
use Illuminate\Http\Request;
use App\Models\CwoBanner;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;
use File;
use App\Traits\Upload;
use Illuminate\Support\Facades\Storage;

class BannerController extends Controller
{
    // protected $carwashclientService;
    use Upload;//add this trait

    // public function __construct(CarWashClientService $carwashclientService)
    public function __construct()
    {
        // $this->carwashclientService = $carwashclientService;
    }

    public function index(Request $request, $cwoid)
    {
        // echo $cwoid;exit;
        $dataBag['chMenu'] = '';
        $data = CwoBanner::where('cwo_id', $cwoid)->orderBy('id', 'desc');
        $dataCnt = $data->count();
        $data = $data->paginate(10);
        $dataBag['allRecords'] = $dataCnt;
        $dataBag['records'] = $data;
        // echo "<pre>";print_r($dataBag['records']->toArray());exit;
        $dataBag['cwoid'] = $cwoid;
        return view('banner.list', $dataBag);
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request, $cwoid)
    {
        $dataBag = array();
        $dataBag['chMenu'] = '';
        $dataBag['cwoid'] = $cwoid;
        return view('banner.create', $dataBag);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $cwoid)
    {
        $request->validate([
            'banner_path' => 'required|image|mimes:jpeg,png,jpg',
        ]);

        $image_name = time() . '.' . $request->file('banner_path')->extension();
        $path = $request->file('banner_path')->move(public_path('images/banner/'), $image_name);
        /*$image_name = '';
        if ($request->hasFile('banner_path')) {
            // $banner_path = $request->file('banner_path');
            // $imageName = time().'.'.$banner_path->extension();
            // $banner_path->move(public_path('upload'), $imageName);
            $image_name = $this->UploadFile($request->file('banner_path'), 'banner');
            
        }*/
        $dt = Carbon::now();
        /*insert into cwo_banners table starts*/
        $record = CwoBanner::create([
                'banner_path'=> $image_name,
                'cwo_id'=> $cwoid,
                'created_at'=>$dt->toDayDateTimeString(),
                'updated_at'=>$dt->toDayDateTimeString()
            ]);
        /*insert into cwo_banners table ends*/

            return back()->with('msg', 'Banner has been added successfully.')->with('msg_class', 'alert alert-success');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($cwoid, $bannerid)
    {
        // echo $cwoid . " - " . $bannerid;exit;
        $dataBag = array();
        $dataBag['chMenu'] = '';
        $record = CwoBanner::findorfail($bannerid);
        $dataBag['details'] = $record;
        $dataBag['cwoid'] = $cwoid;
        return view('banner.edit', $dataBag);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $cwoid, $bannerid)
    {
        // echo $cwoid . " - " . $bannerid;exit;
        $request->validate([
            'banner_path ' => 'image|mimes:jpeg,png,jpg,gif,webp',
        ]);
        $dt = Carbon::now();
        /*update cwo_banners table starts*/
        $data = CwoBanner::findOrFail($bannerid);
        if ($request->hasFile('banner_path')) {
            $image_name = time() . '.' . $request->file('banner_path')->extension();
            $path = $request->file('banner_path')->move(public_path('images/banner/'), $image_name);
        } else {
            $image_name = $data->banner_path;
        }
        /*if ($request->hasFile('banner_path')) {
            // $banner_path = $request->file('banner_path');
            // $imageName = time().'.'.$banner_path->extension();
            // $banner_path->move(public_path('upload'), $imageName);
            $image_name = $this->UploadFile($request->file('banner_path'), 'banner');
            
        } else {
            $image_name = $data->banner_path;
        }*/
        $record = $data->update([
                'banner_path'=> $image_name,
                'updated_at'=>$dt->toDayDateTimeString()
            ]);
        /*update cwo_banners table ends*/
        return back()->with('msg', 'Banner has been updated successfully.')->with('msg_class', 'alert alert-success');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    // public function delete($bannerid){
    //     $record = CwoBanner::findorfail($bannerid); // fetch the record
    //     $record->is_active = "3";
    //     $record->save();
    //     return back()->with('msg', 'Banner has been deleted successfully.')
    //             ->with('msg_class', 'alert alert-success');
    // }
}
