<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Models\CarOwner;
use App\Models\CarOwnerCar;
use App\Services\CarOwnerCarService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class CarOwnersCarController extends Controller
{
    protected $carownercarService;
    protected $carowner_info;
    public function __construct(CarOwnerCarService $carownercarService, Request $request)
    {
        $co_id = $request->route('co_id');
        $this->carowner_info = CarOwner::find($co_id);

        $this->carownercarService = $carownercarService;

        View::share('carowner_info', $this->carowner_info);
    }

    public function index(Request $request, $co_id)
    {
        if ($request->ajax()) {
            $cwo_lists = $this->carownercarService->getAll('', '', $co_id);
            $iTotalRecords = $cwo_lists->count();

            $iDisplayLength = isset($_REQUEST['length']) ? intval($_REQUEST['length']) : 0;
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = isset($_REQUEST['start']) ? intval($_REQUEST['start']) : 0;
            $sEcho = isset($_REQUEST['draw']) ? intval($_REQUEST['draw']) : 0;
            $rowNumber = $iDisplayStart + 1;

            foreach ($cwo_lists as $t) {

                $edit_url = route('admin.coc.edit', ['co_id' => $co_id, 'id' => $t->id]);

                $actionColumnHtml = "<td class='product-action'>
                    <a href =$edit_url ><span class='action-edit'><i class='feather icon-edit'></i></span></a>
                    <a href ='javascript:void(0);' data-id =$t->id class = 'delete_cwo'><span class='action-delete'><i class='feather icon-trash'></i></span></a>
                </td>";

                $is_active = $t->is_active == 1 ? 'checked' : '';

                $status = " <div class='custom-control custom-switch custom-switch-success mr-2 mb-1'>
                <input type='checkbox'  class='custom-control-input change_status' id='customSwitch_$t->id' $is_active data-id=$t->id >
                <label class='custom-control-label' for='customSwitch_$t->id'></label>
                </div>";



                $records["data"][] = array(
                    $rowNumber,
                    '<div class="product-name">' . $t->car_model . '</div>',
                    '<div class="custom-icon-center">' . $t->car_registration_no . '</div>',
                    '<span class="custom-btn">' . $actionColumnHtml . '</span>'

                );
                $rowNumber++;
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            return json_encode($records);
        }
        // $data['coc_id'] = ;

        return view('carwashclient.cars.list');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($co_id)
    {
        $data['car_owner'] = CarOwner::find($co_id);
        return view('carwashclient.cars.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $co_id)
    {

        $data = [
            'co_id' => $co_id,
            'car_model' => $request->car_model,
            'car_registration_no' => $request->car_registration_no
        ];
        CarOwnerCar::create($data);
        return redirect()->back()->with('success', 'Car Created Successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($coc_id, $id)
    {
        //
        $data['co_car'] = CarOwnerCar::find($id);
        // dd($data['co_car'], $id);

        return view('carwashclient.cars.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $co_id, string $id)
    {
        //
        $item = CarOwnerCar::where(['co_id' => $co_id, 'id' => $id])->first();
        // dd($request->all(), $co_id, $id, $item);
        $data = [
            'co_id' => $co_id,
            'car_model' => $request->car_model,
            'car_registration_no' => $request->car_registration_no
        ];
        $item->update($data);
        return redirect()->back()->with('success', 'Car Updated Successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request, string $id)
    {
        $id = $request->id;

        $item = CarOwnerCar::find($id)->delete();
        return response()->json(['message' => 'Car deleted successfully', 'status' => 1], 200);
    }
}
