<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Models\CarOwner;
use App\Models\User;
use App\Services\CarWashClientService;
use Illuminate\Http\Request;
use App\Traits\Upload;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;

class CarWashClientsController extends Controller
{
    use Upload; //add this trait
    protected $carwashclientService;

    public function __construct(CarWashClientService $carwashclientService)
    {
        $this->carwashclientService = $carwashclientService;
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {
            $cwo_lists = $this->carwashclientService->getCarOwner();
            $iTotalRecords = $cwo_lists->count();

            $iDisplayLength = isset($_REQUEST['length']) ? intval($_REQUEST['length']) : 0;
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = isset($_REQUEST['start']) ? intval($_REQUEST['start']) : 0;
            $sEcho = isset($_REQUEST['draw']) ? intval($_REQUEST['draw']) : 0;
            $rowNumber = $iDisplayStart + 1;

            foreach ($cwo_lists as $t) {

                $edit_url = route('admin.cwc.edit', ['id' => $t->id]);
                $car_url = route('admin.coc.list', ['co_id' => $t->id]);

                $actionColumnHtml = "<td class='product-action'>
                    <a href =$edit_url ><span class='action-edit'><i class='feather icon-edit'></i></span></a>
                    <a href =$car_url ><span class='action-edit'><i class='feather icon-life-buoy'></i></span></a>
                    <a href ='javascript:void(0);' data-id =$t->id class = 'delete_cwo'><span class='action-delete'><i class='feather icon-trash'></i></span></a>
                </td>";

                $is_active = $t->is_active == 1 ? 'checked' : '';

                $status = " <div class='custom-control custom-switch custom-switch-success mr-2 mb-1'>
                <input type='checkbox'  class='custom-control-input change_status' id='customSwitch_$t->id' $is_active data-id=$t->id >
                <label class='custom-control-label' for='customSwitch_$t->id'></label>
                </div>";



                $records["data"][] = array(
                    $rowNumber,
                    '<div class="product-name">' . $t->co_fname . ' ' . $t->co_lname . '</div>',
                    '<div class="custom-icon-center">' . $t->co_phone . '</div>',
                    '<div class="product-name">' . $t->user->email . '</div>',
                    $status,
                    '<span class="custom-btn">' . $actionColumnHtml . '</span>'

                );
                $rowNumber++;
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            return json_encode($records);
        }
        return view('carwashclient.list');
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        return view('carwashclient.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $is_active = $request->has('is_active') ? $request->is_active : 1;

        $user = User::create([
            'name' => $request->co_fname . ' ' . $request->co_lname,
            'email' => $request->co_email,
            // 'password' => Hash::make(123456),
            'password' => Hash::make($request->password),
            'phone' => $request->co_phone,
            'is_active' => $is_active,
            'user_type' => 3
        ]);

        $co_image = '';
        if ($request->hasFile('co_image')) {
            $co_image = $request->file('co_image');
            $co_image = $this->UploadFile($request->file('co_image'), 'car_owner');
        }
        // dd($co_image);
        $data = [
            'co_fname' => $request->co_fname,
            'co_lname' => $request->co_lname,
            'co_phone' => $request->co_phone,
            'user_id'  => $user->id,
            // 'co_email' => $request->co_email,
            'is_active' => $is_active,
            'co_image' => $co_image,
        ];
        CarOwner::create($data);
        return redirect()->back()->with('success', 'User Created Successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function edit(Request $request, $id)
    {

        $data['co_user'] = CarOwner::find($id);
        // dd($data['co_user']->user);
        return view('carwashclient.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $is_active = $request->has('is_active') ? $request->is_active : 1;

        $item = CarOwner::findOrFail($id);
        $user_id = $item->user_id;
        $userDetail = User::findOrFail($user_id);

        $co_image = $item->co_image;

        if ($request->hasFile('co_image')) {
            if ($co_image && Storage::disk('public')->exists($co_image)) {
                $this->deleteFile($co_image);
            }
            $co_image = $request->file('co_image');

            $co_image = $this->UploadFile($request->file('co_image'), 'car_owner');
        }

        $data = [
            'co_fname' => $request->co_fname,
            'co_lname' => $request->co_lname,
            'co_phone' => $request->co_phone,

            'is_active' => $is_active,
            'co_image' => $co_image,
        ];
        $item->update($data);

        // update users table starts
        if($request->password != ''){
            $user_data = [
                'name' => $request->co_fname . ' ' . $request->co_lname,
                'email' => $request->co_email,
                'password' => Hash::make($request->password),
                'phone' => $request->co_phone
            ];    
        } else {
            $user_data = [
                'name' => $request->co_fname . ' ' . $request->co_lname,
                'email' => $request->co_email,
                'phone' => $request->co_phone
            ];
        }
        $userDetail->update($user_data);
        // update users table ends

        return redirect()->back()->with('success', 'User Updated Successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        //
        $id = $request->id;
        // dd($id);

        $item = CarOwner::find($id)->delete();
        return response()->json(['message' => 'User deleted successfully', 'status' => 1], 200);
    }
    public function delete_image(Request $request)
    {
        $id = $request->id;
        $item = CarOwner::findOrFail($id);
        $co_image = $item->co_image;

        if ($co_image && Storage::disk('public')->exists($co_image)) {
            $this->deleteFile($co_image);
        }

        $data = [
            'co_image' => '',
        ];
        $item->update($data);
        return response()->json(['message' => 'User status changed successfully', 'status' => 1], 200);
    }
    public function downloadList(Request $request)
    {
        $selectedColumn = ['co_fname', 'co_phone', 'co_email', 'is_active'];
        $csv_header = ['Name', 'Phone', 'Email', 'Status'];

        $cwo_lists = $this->carwashclientService->getCarOwner($selectedColumn, $request);

        $_data = $cwo_lists->toArray();
        $csv_data = [$csv_header, ...$_data];

        csvDownlaod($csv_data, 'car_owner_list.csv');
    }

    public function status_change_ajax(Request $request)
    {
        try {
            $user_data = CarOwner::where('id', $request->id)->first();
            if ($user_data != null) {
                $user_data->is_active = $request->status;
                $user_data->save();

                return response()->json(['message' => 'User status changed successfully', 'status' => 1], 200);
            } else {
                return response()->json(['message' => 'User not found', 'status' => 0], 401);
            }
        } catch (exception $e) {
        }
    }
    public function download(Request $request)
    {
        $fileName = 'car-owners.csv';

        $data = CarOwner::with('user')->orderBy('id', 'asc');

        $data = $data->get();

        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

        $columns = array('Name', 'Phone', 'Email', 'Status');

        $callback = function() use($data, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($data as $d) {
                $row['co_name']  = $d->co_fname . ' ' . $d->co_lname;
                $row['co_phone']  = $d->co_phone;
                $row['email']  = $d->user->email;
                if($d->is_active == 1){
                    $row['is_active']  = 'Active';
                } else {
                    $row['is_active']  = 'Inactive';
                }
                

                fputcsv($file, array($row['co_name'], $row['co_phone'], $row['email'], $row['is_active']));
            }

            fclose($file);
        };

        return response()->stream($callback, 200, $headers);
    }

}
