<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Models\CarWashOwner;
use App\Models\CurrencyMaster;
use Illuminate\Http\Request;
use App\Services\CarWashOwnerService;

use File;
use App\Models\Demo;
use App\Traits\Upload;
use Illuminate\Support\Facades\Storage;

class CarWashOwnerController extends Controller
{
    protected $carwashownerService;
    use Upload; //add this trait

    public function __construct(CarWashOwnerService $carwashownerService)
    {
        $this->carwashownerService = $carwashownerService;
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $cwo_lists = $this->carwashownerService->getCarWashOwner();
            $iTotalRecords = $cwo_lists->count();

            $iDisplayLength = isset($_REQUEST['length']) ? intval($_REQUEST['length']) : 0;
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = isset($_REQUEST['start']) ? intval($_REQUEST['start']) : 0;
            $sEcho = isset($_REQUEST['draw']) ? intval($_REQUEST['draw']) : 0;
            $rowNumber = $iDisplayStart + 1;
            // dd($cwo_lists);
            foreach ($cwo_lists as $t) {

                $edit_url = route('admin.cwo.edit', ['id' => $t->id]);
                $user_url = route('admin.cu.user.list', ['cwoid' => $t->id]);
                $banner_url = route('admin.banner.list', ['cwoid' => $t->id]);

                $actionColumnHtml = "<td class='product-action'>
                    <a href =$edit_url ><span class='action-edit'><i class='feather icon-edit'></i></span></a>
                    <a href =$user_url ><span class='action-edit'><i class='feather icon-user'></i></span></a>
                    <a href =$banner_url ><span class='action-edit'><i class='feather icon-image'></i></span></a>
                    <a href ='javascript:void(0);' data-id =$t->id class = 'delete_cwo'><span class='action-delete'><i class='feather icon-trash'></i></span></a>
                </td>";

                $is_active = $t->is_active == 1 ? 'checked' : '';

                $status = " <div class='custom-control custom-switch custom-switch-success mr-2 mb-1'>
                <input type='checkbox'  class='custom-control-input change_status' id='customSwitch_$t->id' $is_active data-id=$t->id >
                <label class='custom-control-label' for='customSwitch_$t->id'></label>
                </div>";



                $records["data"][] = array(
                    $rowNumber,
                    // '',
                    '<div class="product-name">' . $t->cwo_name . '</div>',
                    '<div class="product-name">' . $t->cwo_email . '</div>',
                    '<div class="custom-icon-center">' . $t->cwo_phone . '</div>',
                    '<div class="custom-icon-center">' . $t->cwo_company . '</div>',
                    $status,
                    '<span class="custom-btn">' . $actionColumnHtml . '</span>'

                );
                $rowNumber++;
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            return json_encode($records);
        }
        return view('carwashowner.list');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $dataBag['currencies'] = CurrencyMaster::orderBy('id', 'asc')->get();
        return view('carwashowner.create', $dataBag);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //

        // $request->validate([
        //     'cwo_logo' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048', // Adjust validation rules as needed
        // ]);

        $cwo_logo = '';
        if ($request->hasFile('cwo_logo')) {
            $cwo_logo = $request->file('cwo_logo');
            $imageName = time() . '.' . $cwo_logo->extension();
            // $cwo_logo->move(public_path('upload'), $imageName);

            $cwo_logo = $this->UploadFile($request->file('cwo_logo'), 'car_wash_owner');
        }
        // dd($cwo_logo);
        $data = [
            'cwo_name' => $request->cwo_name,
            'cwo_isd' => $request->cwo_isd,
            'cwo_phone' => $request->cwo_phone,
            'cwo_email' => $request->cwo_email,
            'cwo_company' => $request->cwo_company,
            'cwo_business_details' => $request->cwo_business_details,
            'is_active' => $request->has('is_active') ? $request->is_active : 1,
            'cwo_logo' => $cwo_logo,
            'currency_id' => $request->currency_id,
            'address' => $request->address,
        ];
        CarWashOwner::create($data);
        return redirect()->back()->with('success', 'User Created Successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Request $request, $id)
    {

        $data['cwo_user'] = CarWashOwner::find($id);
        $data['currencies'] = CurrencyMaster::orderBy('id', 'asc')->get();
        return view('carwashowner.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $item = CarWashOwner::findOrFail($id);

        $cwo_logo = $item->cwo_logo;

        // dd(Storage::disk('public')->exists($cwo_logo),$cwo_logo);
        if ($request->hasFile('cwo_logo')) {
            if ($cwo_logo && Storage::disk('public')->exists($cwo_logo)) {
                $this->deleteFile($cwo_logo);
            }
            $cwo_logo = $request->file('cwo_logo');

            $cwo_logo = $this->UploadFile($request->file('cwo_logo'), 'car_wash_owner');
        }

        $data = [
            'cwo_name' => $request->cwo_name,
            'cwo_isd' => $request->cwo_isd,
            'cwo_phone' => $request->cwo_phone,
            'cwo_email' => $request->cwo_email,
            'cwo_company' => $request->cwo_company,
            'cwo_business_details' => $request->cwo_business_details,
            'is_active' => $request->has('is_active') ? $request->is_active : 1,
            'cwo_logo' => $cwo_logo,
            'currency_id' => $request->currency_id,
            'address' => $request->address,
        ];
        $item->update($data);
        return redirect()->back()->with('success', 'User Updated Successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        //
        $id = $request->id;
        // dd($id);

        $item = CarWashOwner::find($id)->delete();
        return response()->json(['message' => 'User deleted successfully', 'status' => 1], 200);
    }
    public function delete_image(Request $request)
    {
        $id = $request->id;
        $item = CarWashOwner::findOrFail($id);
        $cwo_logo = $item->cwo_logo;

        if ($cwo_logo && Storage::disk('public')->exists($cwo_logo)) {
            $this->deleteFile($cwo_logo);
        }

        $data = [
            'cwo_logo' => '',
        ];
        $item->update($data);
        return response()->json(['message' => 'User status changed successfully', 'status' => 1], 200);
    }
    public function downloadList(Request $request)
    {
        $selectedColumn = ['cwo_name', 'cwo_phone', 'cwo_email', 'cwo_company', 'cwo_business_details', 'is_active'];
        $csv_header = ['Name', 'Phone', 'Email', 'Company', 'Business Details', 'Status'];

        $cwo_lists = $this->carwashownerService->getCarWashOwner($selectedColumn, $request);

        $_data = $cwo_lists->toArray();
        $csv_data = [$csv_header, ...$_data];

        csvDownlaod($csv_data, 'cwo_list.csv');
    }

    public function status_change_ajax(Request $request)
    {
        try {
            $user_data = CarWashOwner::where('id', $request->id)->first();
            if ($user_data != null) {
                $user_data->is_active = $request->status;
                $user_data->save();

                return response()->json(['message' => 'User status changed successfully', 'status' => 1], 200);
            } else {
                return response()->json(['message' => 'User not found', 'status' => 0], 401);
            }
        } catch (exception $e) {
        }
    }
}
