<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
// use App\Services\CarSearchService;
use Illuminate\Http\Request;
use App\Models\WashDetail;

class CarWashReportController extends Controller
{
    // protected $carsearchService;

    // public function __construct(CarSearchService $carsearchService)
    // {
    //     $this->carsearchService = $carsearchService;
    // }
    public function __construct()
    {
    }

    public function index(Request $request)
    {
        // echo "search car";exit;
        $dataBag = array();
        $dataBag['chMenu'] = 'carWashReportList';
        $data = WashDetail::select('wash_details.id','wash_details.car_id','wash_details.entry_date','wash_details.wash_type_id','wash_details.body_type','wash_details.amount','wash_details.date_washed','wash_details.time_washed','wash_details.status','wash_details.payment_status','wash_details.payment_details','cwo_master.cwo_name','cwo_master.cwo_company','co_master.co_fname','co_master.co_lname','co_master.co_phone','users.email','co_car.car_registration_no','wash_categories.wash_name','currency_masters.symbol')
        ->join('co_car','co_car.id','=','wash_details.car_id')
        ->join('co_master','co_master.id','=','co_car.co_id')
        ->join('users','users.id','=','co_master.user_id')
        ->join('wash_categories','wash_categories.id','=','wash_details.wash_type_id')
        ->join('cwo_master','cwo_master.id','=','wash_categories.cwo_id')
        ->leftJoin('currency_masters','currency_masters.id','=','cwo_master.currency_id')
        ->orderBy('co_car.id', 'desc');

        $dataCnt = $data->count();
        $data = $data->paginate(10);
        $dataBag['allRecords'] = $dataCnt;
        $dataBag['records'] = $data;
        // echo "<pre>";print_r($dataBag['records']->toArray());exit;
        return view('washreport.list', $dataBag);
        
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function download(Request $request)
    {
        $fileName = 'car-wash-report.csv';

        $data = WashDetail::select('wash_details.id','wash_details.car_id','wash_details.entry_date','wash_details.wash_type_id','wash_details.body_type','wash_details.amount','wash_details.date_washed','wash_details.time_washed','wash_details.status','wash_details.payment_status','wash_details.payment_details','cwo_master.cwo_name','cwo_master.cwo_company','co_master.co_fname','co_master.co_lname','co_master.co_phone','users.email','co_car.car_registration_no','wash_categories.wash_name','currency_masters.symbol')
        ->join('co_car','co_car.id','=','wash_details.car_id')
        ->join('co_master','co_master.id','=','co_car.co_id')
        ->join('users','users.id','=','co_master.user_id')
        ->join('wash_categories','wash_categories.id','=','wash_details.wash_type_id')
        ->join('cwo_master','cwo_master.id','=','wash_categories.cwo_id')
        ->leftJoin('currency_masters','currency_masters.id','=','cwo_master.currency_id')
        ->orderBy('co_car.id', 'desc');

        $data = $data->get();

        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

        $columns = array('CWO Name', 'Client Name', 'Client Email', 'Client Phone', 'Car Registration No.', 'Body Type', 'Car Wash Type', 'Amount', 'Date Washed', 'Time Washed', 'Car Wash Status', 'Payment Status', 'Payment Type');

        $callback = function() use($data, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($data as $d) {
                $row['cwo_name']  = $d->cwo_name;
                $row['co_fname']  = $d->co_fname . ' ' . $d->co_lname;
                $row['email']  = $d->email;
                $row['co_phone']  = $d->co_phone;
                $row['car_registration_no']  = $d->car_registration_no;
                $row['body_type']  = $d->body_type;
                $row['wash_name']  = $d->wash_name;
                $row['amount']  = $d->symbol . $d->amount;
                if($d->date_washed != ''){
                    $row['date_washed']  = date("jS M Y", strtotime($d->date_washed));    
                } else {
                    $row['date_washed'] = '';
                }
                if($d->time_washed != ''){
                    $row['time_washed']  = date("h:i a", strtotime($d->time_washed));    
                } else {
                    $row['time_washed'] = '';
                }
                if($d->status == 1){
                    $row['status']  = 'Completed';
                } else {
                    $row['status']  = 'Pending';
                }
                if($d->payment_status == 1){
                    $row['payment_status']  = 'Completed';
                } else {
                    $row['payment_status']  = 'Pending';
                }
                $row['payment_details']  = $d->payment_details;
                

                fputcsv($file, array($row['cwo_name'], $row['co_fname'], $row['email'], $row['co_phone'], $row['car_registration_no'], $row['body_type'], $row['wash_name'], $row['amount'], $row['date_washed'], $row['time_washed'], $row['status'], $row['payment_status'], $row['payment_details']));
            }

            fclose($file);
        };

        return response()->stream($callback, 200, $headers);
    }
}
