<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
// use App\Services\CarWashClientService;
use Illuminate\Http\Request;
// use App\Models\CwoUnit;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;

class CwoUserController extends Controller
{
    // protected $carwashclientService;

    // public function __construct(CarWashClientService $carwashclientService)
    public function __construct()
    {
        // $this->carwashclientService = $carwashclientService;
    }

    // public function index(Request $request, $cwoid)
    // {
    //     // echo $cwoid;exit;
    //     $dataBag['chMenu'] = '';
    //     $data = CwoUnit::where('cwo_id', $cwoid)->where('is_active', '!=' , 3)->orderBy('id', 'desc');
    //     $dataCnt = $data->count();
    //     $data = $data->paginate(10);
    //     $dataBag['allRecords'] = $dataCnt;
    //     $dataBag['records'] = $data;
    //     // echo "<pre>";print_r($dataBag['records']->toArray());exit;
    //     $dataBag['cwoid'] = $cwoid;
    //     return view('unit.list', $dataBag);
    // }

    public function listUser(Request $request, $cwoid)
    {
        // echo $cwoid;exit;
        $dataBag['chMenu'] = '';
        $data = User::with('cwoDetail')->where('cwo_id', $cwoid)->where('user_type', 2)->orderBy('id', 'desc');
        $dataCnt = $data->count();
        $data = $data->paginate(10);
        $dataBag['allRecords'] = $dataCnt;
        $dataBag['records'] = $data;
        // echo "<pre>";print_r($dataBag['records']->toArray());exit;
        $dataBag['cwoid'] = $cwoid;
        return view('cwouser.list', $dataBag);
    }

    public function createUser(Request $request, $cwoid)
    {
        $dataBag = array();
        $dataBag['chMenu'] = '';
        $dataBag['cwoid'] = $cwoid;
        return view('cwouser.create', $dataBag);
    }

    public function storeUser(Request $request, $cwoid)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users,email',
            'is_active' => 'required',
            // 'phone' => 'numeric|nullable',
            'password' => [
                'required',
                // 'string',
                // 'min:6',             // must be at least 6 characters in length
                // 'regex:/[a-z]/',      // must contain at least one lowercase letter
                // 'regex:/[A-Z]/',      // must contain at least one uppercase letter
                // 'regex:/[0-9]/',      // must contain at least one digit
                // 'regex:/[!@#$%^&*()]/', // must contain a special character
            ]
        ],[
            'name.required' => 'Please enter a name.',
            'email.required' => 'Please enter an email.',
            'email.email' => 'Please enter an email of correct format.',
            'email.unique' => 'This Email-id already exist, Try Another.',
            'is_active.required' => 'Please select a status.',
            'password.required' => 'Please enter a password.',
            // 'password.regex' => 'Password must contain atleast one lowercase letter, one uppercase letter, one digit & a special character.',
            // 'phone.numeric' => 'Phoneno. should be numeric.',
        ]);
        $name = $request->input('name');
        $email = $request->input('email');
        $phone = $request->input('phone');
        $is_active = $request->input('is_active');
        $password = Hash::make($request->input('password'));
        $dt = Carbon::now();
        /*insert into users table starts*/
        $record = User::create([
                'name'=> $name,
                'email'=> $email,
                'password'=> $password,
                'user_type'=> 2,
                'is_active'=> $is_active,
                'phone'=> $phone,
                'cwo_id'=> $cwoid,
                'created_at'=>$dt->toDayDateTimeString(),
                'updated_at'=>$dt->toDayDateTimeString()
            ]);
        /*insert into users table ends*/

            return back()->with('success', 'User has been added successfully.')->with('msg_class', 'alert alert-success');
    }

    public function editUser($cwoid, $userid)
    {
        // echo $cwoid . " - " . $cwoid;exit;
        $dataBag = array();
        $dataBag['chMenu'] = '';
        $record = User::findorfail($userid);
        $dataBag['details'] = $record;
        $dataBag['cwoid'] = $cwoid;
        return view('cwouser.edit', $dataBag);
    }

    public function updateUser(Request $request, $cwoid, $userid)
    {
        // echo $cwoid . " - " . $userid;exit;
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users,email,' . $userid,
            'is_active' => 'required',
            // 'phone' => 'numeric|nullable',
            // 'password' => [
            //     'required',
            //     'string',
            //     'min:6',             // must be at least 6 characters in length
            //     'regex:/[a-z]/',      // must contain at least one lowercase letter
            //     'regex:/[A-Z]/',      // must contain at least one uppercase letter
            //     'regex:/[0-9]/',      // must contain at least one digit
            //     'regex:/[!@#$%^&*()]/', // must contain a special character
            // ]
        ],[
            'name.required' => 'Please enter a name.',
            'email.required' => 'Please enter an email.',
            'email.email' => 'Please enter an email of correct format.',
            'email.unique' => 'This Email-id already exist, Try Another.',
            'is_active.required' => 'Please select a status.',
            // 'password.required' => 'Please enter a password.',
            // 'password.regex' => 'Password must contain atleast one lowercase letter, one uppercase letter, one digit & a special character.',
            // 'phone.numeric' => 'Phoneno. should be numeric.',
        ]);
        $name = $request->input('name');
        $email = $request->input('email');
        $phone = $request->input('phone');
        $is_active = $request->input('is_active');
        $dt = Carbon::now();
        /*update users table starts*/
        $data = User::findOrFail($userid);
        if($request->input('password') != ''){
            $password = Hash::make($request->input('password'));
            $record = $data->update([
                'name'=> $name,
                'email'=> $email,
                'password'=> $password,
                'is_active'=> $is_active,
                'phone'=> $phone,
                'updated_at'=>$dt->toDayDateTimeString()
            ]);
        } else {
            $record = $data->update([
                'name'=> $name,
                'email'=> $email,
                'is_active'=> $is_active,
                'phone'=> $phone,
                'updated_at'=>$dt->toDayDateTimeString()
            ]);
        }
        
        /*update users table ends*/
        return back()->with('success', 'User has been updated successfully.')->with('msg_class', 'alert alert-success');
    }

    public function deleteUser($userid){
        $record = User::findorfail($userid); // fetch the record
        $record->is_active = "0";
        $record->save();
        return back()->with('msg', 'User has been deleted successfully.')
                ->with('msg_class', 'alert alert-success');
    }
}
