<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Services\SubUserService;
use Illuminate\Http\Request;

class SubUserController extends Controller
{
    protected $subuserService;

    public function __construct(SubUserService $subuserService)
    {
        $this->subuserService = $subuserService;
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {
            $cwo_lists = $this->subuserService->getCarWashOwner();
            $iTotalRecords = $cwo_lists->count();

            $iDisplayLength = isset($_REQUEST['length']) ? intval($_REQUEST['length']) : 0;
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = isset($_REQUEST['start']) ? intval($_REQUEST['start']) : 0;
            $sEcho = isset($_REQUEST['draw']) ? intval($_REQUEST['draw']) : 0;
            $rowNumber = $iDisplayStart + 1;

            foreach ($cwo_lists as $t) {

                $actionColumnHtml = '<td class="product-action">
                <span class="action-edit"><i class="feather icon-edit"></i></span>
                <span class="action-delete"><i class="feather icon-trash"></i></span>
                </td>';
                if ($t->status == 1) {
                    $status = '<div class="chip  chip-success">
                    <div class="chip-body">
                        <div class="chip-text">Active</div>
                    </div>
                </div>';
                } else {

                    $status = '<div class="chip  chip-danger">
                                <div class="chip-body">
                                    <div class="chip-text">Inactive</div>
                                </div>
                            </div>';
                }



                $records["data"][] = array(
                    // $rowNumber,
                    '',
                    '<div class="product-name">' . $t->acc_id . '</div>',
                    '<div class="product-name">' . $t->company . '</div>',
                    '<div class="custom-icon-center">' . $t->phone . '</div>',
                    '<div class="custom-icon-center">' . $t->name . '</div>',
                    '<div class="custom-icon-center">' . $t->bemail . '</div>',
                    '<div class="custom-icon-center">' . $t->bphone . '</div>',
                    '<div class="custom-icon-center">' . $t->email . '</div>',
                    $status,
                    '<div class="custom-icon-center">' . $t->reg_date . '</div>',
                    '<span class="custom-btn">' . $actionColumnHtml . '</span>'

                );
                $rowNumber++;
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            return json_encode($records);
        }
        return view('subusers.list');
    }


    public function create()
    {
        return view('subusers.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //

        dd($request->all());
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
    public function downloadList(Request $request)
    {
        $selectedColumn = ['company', 'acc_id', 'bphone', 'name', 'bemail', 'phone', 'email', 'status', 'reg_date'];
        $csv_header = ['Company', 'Account Number', 'Business Contact Number', 'Contact Person', 'Business Email Address', 'Contact', 'Email', 'Status', 'Date'];

        $cwo_lists = $this->subuserService->getCarWashOwner($selectedColumn, $request);

        $_data = $cwo_lists->toArray();
        $csv_data = [$csv_header, ...$_data];

        csvDownlaod($csv_data, 'cwo_list.csv');
    }
}
