<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
// use App\Services\CarWashClientService;
use Illuminate\Http\Request;
use App\Models\CwoUnit;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;

class UnitController extends Controller
{
    // protected $carwashclientService;

    // public function __construct(CarWashClientService $carwashclientService)
    public function __construct()
    {
        // $this->carwashclientService = $carwashclientService;
    }

    public function index(Request $request, $cwoid)
    {
        // echo $cwoid;exit;
        $dataBag['chMenu'] = '';
        $data = CwoUnit::where('cwo_id', $cwoid)->where('is_active', '!=' , 3)->orderBy('id', 'desc');
        $dataCnt = $data->count();
        $data = $data->paginate(10);
        $dataBag['allRecords'] = $dataCnt;
        $dataBag['records'] = $data;
        // echo "<pre>";print_r($dataBag['records']->toArray());exit;
        $dataBag['cwoid'] = $cwoid;
        return view('unit.list', $dataBag);
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request, $cwoid)
    {
        $dataBag = array();
        $dataBag['chMenu'] = '';
        $dataBag['cwoid'] = $cwoid;
        return view('unit.create', $dataBag);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $cwoid)
    {
        $request->validate([
            'unit_name' => 'required',
            'cwo_address' => 'required',
            'unit_email' => 'required|email',
            'unit_phone' => 'required|numeric',
            'is_active' => 'required'
        ],[
            'unit_name.required' => 'Please enter an unit name.',
            'cwo_address.required' => 'Please enter an unit address.',
            'unit_email.required' => 'Please enter an email.',
            'unit_email.email' => 'Email should be in correct format.',
            'unit_phone.required' => 'Please enter a phone no.',
            'unit_phone.numeric' => 'Phone no. should be numeric.',
            'is_active.required' => 'Please select a status.'
        ]);
        $unit_name = $request->input('unit_name');
        $cwo_address = $request->input('cwo_address');
        $unit_email = $request->input('unit_email');
        $unit_phone = $request->input('unit_phone');
        $is_active = $request->input('is_active');
        $dt = Carbon::now();
        /*insert into cwo_units table starts*/
        $record = CwoUnit::create([
                'unit_name'=> $unit_name,
                'cwo_address'=> $cwo_address,
                'unit_email'=> $unit_email,
                'unit_phone'=> $unit_phone,
                'is_active'=> $is_active,
                'cwo_id'=> $cwoid,
                'created_at'=>$dt->toDayDateTimeString(),
                'updated_at'=>$dt->toDayDateTimeString()
            ]);
        /*insert into cwo_units table ends*/

            return back()->with('success', 'Unit has been added successfully.')->with('msg_class', 'alert alert-success');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($cwoid, $unitid)
    {
        // echo $cwoid . " - " . $unitid;exit;
        $dataBag = array();
        $dataBag['chMenu'] = '';
        $record = CwoUnit::findorfail($unitid);
        $dataBag['details'] = $record;
        $dataBag['cwoid'] = $cwoid;
        return view('unit.edit', $dataBag);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $cwoid, $unitid)
    {
        // echo $cwoid . " - " . $unitid;exit;
        $request->validate([
            'unit_name' => 'required',
            'cwo_address' => 'required',
            'unit_email' => 'required|email',
            'unit_phone' => 'required|numeric',
            'is_active' => 'required'
        ],[
            'unit_name.required' => 'Please enter an unit name.',
            'cwo_address.required' => 'Please enter an unit address.',
            'unit_email.required' => 'Please enter an email.',
            'unit_email.email' => 'Email should be in correct format.',
            'unit_phone.required' => 'Please enter a phone no.',
            'unit_phone.numeric' => 'Phone no. should be numeric.',
            'is_active.required' => 'Please select a status.'
        ]);
        $unit_name = $request->input('unit_name');
        $cwo_address = $request->input('cwo_address');
        $unit_email = $request->input('unit_email');
        $unit_phone = $request->input('unit_phone');
        $is_active = $request->input('is_active');
        $dt = Carbon::now();
        /*update cwo_units table starts*/
        $data = CwoUnit::findOrFail($unitid);
        $record = $data->update([
                'unit_name'=> $unit_name,
                'cwo_address'=> $cwo_address,
                'unit_email'=> $unit_email,
                'unit_phone'=> $unit_phone,
                'is_active'=> $is_active,
                'updated_at'=>$dt->toDayDateTimeString()
            ]);
        /*update cwo_units table ends*/
        return back()->with('success', 'Unit has been updated successfully.')->with('msg_class', 'alert alert-success');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function delete($unitid){
        $record = CwoUnit::findorfail($unitid); // fetch the record
        $record->is_active = "3";
        $record->save();
        return back()->with('msg', 'Unit has been deleted successfully.')
                ->with('msg_class', 'alert alert-success');
    }

    public function listUser(Request $request, $unitid)
    {
        // echo $unitid;exit;
        $dataBag['chMenu'] = '';
        $data = User::with('unitDetail')->where('cwo_unit_id', $unitid)->where('user_type', 4)->orderBy('id', 'desc');
        $dataCnt = $data->count();
        $data = $data->paginate(10);
        $dataBag['allRecords'] = $dataCnt;
        $dataBag['records'] = $data;
        // echo "<pre>";print_r($dataBag['records']->toArray());exit;
        $dataBag['unitid'] = $unitid;
        return view('unituser.list', $dataBag);
    }

    public function createUser(Request $request, $unitid)
    {
        $dataBag = array();
        $dataBag['chMenu'] = '';
        $dataBag['unitid'] = $unitid;
        return view('unituser.create', $dataBag);
    }

    public function storeUser(Request $request, $unitid)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users,email',
            'is_active' => 'required',
            'phone' => 'numeric|nullable',
            'password' => [
                'required',
                // 'string',
                // 'min:6',             // must be at least 6 characters in length
                // 'regex:/[a-z]/',      // must contain at least one lowercase letter
                // 'regex:/[A-Z]/',      // must contain at least one uppercase letter
                // 'regex:/[0-9]/',      // must contain at least one digit
                // 'regex:/[!@#$%^&*()]/', // must contain a special character
            ]
        ],[
            'name.required' => 'Please enter a name.',
            'email.required' => 'Please enter an email.',
            'email.email' => 'Please enter an email of correct format.',
            'email.unique' => 'This Email-id already exist, Try Another.',
            'is_active.required' => 'Please select a status.',
            'password.required' => 'Please enter a password.',
            // 'password.regex' => 'Password must contain atleast one lowercase letter, one uppercase letter, one digit & a special character.',
            'phone.numeric' => 'Phoneno. should be numeric.',
        ]);
        $name = $request->input('name');
        $email = $request->input('email');
        $phone = $request->input('phone');
        $is_active = $request->input('is_active');
        $password = Hash::make($request->input('password'));
        $dt = Carbon::now();
        /*insert into users table starts*/
        $record = User::create([
                'name'=> $name,
                'email'=> $email,
                'password'=> $password,
                'user_type'=> 4,
                'is_active'=> $is_active,
                'phone'=> $phone,
                'cwo_unit_id'=> $unitid,
                'created_at'=>$dt->toDayDateTimeString(),
                'updated_at'=>$dt->toDayDateTimeString()
            ]);
        /*insert into users table ends*/

            return back()->with('success', 'Unit user has been added successfully.')->with('msg_class', 'alert alert-success');
    }

    public function editUser($unitid, $userid)
    {
        // echo $unitid . " - " . $unitid;exit;
        $dataBag = array();
        $dataBag['chMenu'] = '';
        $record = User::findorfail($userid);
        $dataBag['details'] = $record;
        $dataBag['unitid'] = $unitid;
        return view('unituser.edit', $dataBag);
    }

    public function updateUser(Request $request, $unitid, $userid)
    {
        // echo $unitid . " - " . $userid;exit;
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users,email,' . $userid,
            'is_active' => 'required',
            'phone' => 'numeric|nullable',
            // 'password' => [
            //     'required',
            //     'string',
            //     'min:6',             // must be at least 6 characters in length
            //     'regex:/[a-z]/',      // must contain at least one lowercase letter
            //     'regex:/[A-Z]/',      // must contain at least one uppercase letter
            //     'regex:/[0-9]/',      // must contain at least one digit
            //     'regex:/[!@#$%^&*()]/', // must contain a special character
            // ]
        ],[
            'name.required' => 'Please enter a name.',
            'email.required' => 'Please enter an email.',
            'email.email' => 'Please enter an email of correct format.',
            'email.unique' => 'This Email-id already exist, Try Another.',
            'is_active.required' => 'Please select a status.',
            // 'password.required' => 'Please enter a password.',
            // 'password.regex' => 'Password must contain atleast one lowercase letter, one uppercase letter, one digit & a special character.',
            'phone.numeric' => 'Phoneno. should be numeric.',
        ]);
        $name = $request->input('name');
        $email = $request->input('email');
        $phone = $request->input('phone');
        $is_active = $request->input('is_active');
        $dt = Carbon::now();
        /*update users table starts*/
        $data = User::findOrFail($userid);
        $record = $data->update([
                'name'=> $name,
                'email'=> $email,
                'is_active'=> $is_active,
                'phone'=> $phone,
                'updated_at'=>$dt->toDayDateTimeString()
            ]);
        /*update users table ends*/
        return back()->with('success', 'Unit user has been updated successfully.')->with('msg_class', 'alert alert-success');
    }

    public function deleteUser($userid){
        $record = User::findorfail($userid); // fetch the record
        $record->is_active = "0";
        $record->save();
        return back()->with('msg', 'Unit user has been deleted successfully.')
                ->with('msg_class', 'alert alert-success');
    }
}
