<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
// use App\Services\CarWashClientService;
use Illuminate\Http\Request;
use App\Models\CarWashOwner;
use App\Models\WashCategory;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;

class WashCategoryController extends Controller
{
    // protected $carwashclientService;

    // public function __construct(CarWashClientService $carwashclientService)
    public function __construct()
    {
        // $this->carwashclientService = $carwashclientService;
    }

    public function index(Request $request)
    {
        // echo $cwoid;exit;
        $dataBag['chMenu'] = '';
        $data = WashCategory::with('cwoDetail')->where('is_active', '!=' , 3)->orderBy('id', 'desc');
        $dataCnt = $data->count();
        $data = $data->paginate(10);
        $dataBag['allRecords'] = $dataCnt;
        $dataBag['records'] = $data;
        // echo "<pre>";print_r($dataBag['records']->toArray());exit;
        return view('washcategory.list', $dataBag);
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        $dataBag = array();
        $dataBag['chMenu'] = '';
        // $dataBag['cwo'] = CarWashOwner::where('is_active', 1)->orderBy('id', 'desc')->select('id', 'cwo_name', 'cwo_company')->get();
        $dataBag['cwo'] = CarWashOwner::with('currencyDetail')->where('is_active', 1)->orderBy('id', 'desc')->get();
        // echo "<pre>";print_r($dataBag['cwo']->toArray());exit;
        return view('washcategory.create', $dataBag);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // echo "store";exit;
        $request->validate([
            'wash_name' => 'required|unique:wash_categories,wash_name',
            'wash_desc' => 'required',
            'cwo_id' => 'required',
            'price_sedan_hatchback' => 'numeric|nullable',
            'price_suv_cab' => 'numeric|nullable',
            'price_van_mini' => 'numeric|nullable',
            'price_tucks_busses' => 'numeric|nullable',
            'is_active' => 'required'
        ],[
            'wash_name.required' => 'Please enter wash name.',
            'wash_name.unique' => 'This Wash name already exists.',
            'wash_desc.required' => 'Please enter wash description.',
            'cwo_id.required' => 'Please select a car wash owner.',
            'price_sedan_hatchback.numeric' => 'Price sedan hatchback should be numeric.',
            'price_suv_cab.numeric' => 'Price suv cab should be numeric.',
            'price_van_mini.numeric' => 'Price van mini should be numeric.',
            'price_tucks_busses.numeric' => 'Price trucks busses should be numeric.',
            'is_active.required' => 'Please select a status.'
        ]);
        $wash_name = $request->input('wash_name');
        $wash_desc = $request->input('wash_desc');
        $cwo_id = $request->input('cwo_id');
        $price_sedan_hatchback = $request->input('price_sedan_hatchback');
        $price_suv_cab = $request->input('price_suv_cab');
        $price_van_mini = $request->input('price_van_mini');
        $price_tucks_busses = $request->input('price_tucks_busses');
        $is_active = $request->input('is_active');
        $dt = Carbon::now();
        /*insert into wash_categories table starts*/
        $record = WashCategory::create([
                'wash_name'=> $wash_name,
                'wash_desc'=> $wash_desc,
                'cwo_id'=> $cwo_id,
                'price_sedan_hatchback'=> $price_sedan_hatchback,
                'price_suv_cab'=> $price_suv_cab,
                'price_van_mini'=> $price_van_mini,
                'price_tucks_busses'=> $price_tucks_busses,
                'is_active'=> $is_active,
                'created_at'=>$dt->toDayDateTimeString(),
                'updated_at'=>$dt->toDayDateTimeString()
            ]);
        /*insert into wash_categories table ends*/

            return back()->with('success', 'Wash Category has been added successfully.')->with('msg_class', 'alert alert-success');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        // echo $cwoid . " - " . $unitid;exit;
        $dataBag = array();
        $dataBag['chMenu'] = '';
        $record = WashCategory::findorfail($id);
        $dataBag['details'] = $record;
        // $dataBag['cwo'] = CarWashOwner::where('is_active', 1)->orderBy('id', 'desc')->select('id', 'cwo_name', 'cwo_company')->get();
        $dataBag['cwo'] = CarWashOwner::with('currencyDetail')->where('is_active', 1)->orderBy('id', 'desc')->get();
        return view('washcategory.edit', $dataBag);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        // echo $id;exit;
        $request->validate([
            'wash_name' => 'required|unique:wash_categories,wash_name,' . $id,
            'wash_desc' => 'required',
            'cwo_id' => 'required',
            'price_sedan_hatchback' => 'numeric|nullable',
            'price_suv_cab' => 'numeric|nullable',
            'price_van_mini' => 'numeric|nullable',
            'price_tucks_busses' => 'numeric|nullable',
            'is_active' => 'required'
        ],[
            'wash_name.required' => 'Please enter wash name.',
            'wash_name.unique' => 'This Wash name already exists.',
            'wash_desc.required' => 'Please enter wash description.',
            'cwo_id.required' => 'Please select a car wash owner.',
            'price_sedan_hatchback.numeric' => 'Price sedan hatchback should be numeric.',
            'price_suv_cab.numeric' => 'Price suv cab should be numeric.',
            'price_van_mini.numeric' => 'Price van mini should be numeric.',
            'price_tucks_busses.numeric' => 'Price trucks busses should be numeric.',
            'is_active.required' => 'Please select a status.'
        ]);
        $wash_name = $request->input('wash_name');
        $wash_desc = $request->input('wash_desc');
        $cwo_id = $request->input('cwo_id');
        $price_sedan_hatchback = $request->input('price_sedan_hatchback');
        $price_suv_cab = $request->input('price_suv_cab');
        $price_van_mini = $request->input('price_van_mini');
        $price_tucks_busses = $request->input('price_tucks_busses');
        $is_active = $request->input('is_active');
        $dt = Carbon::now();
        /*update wash_categories table starts*/
        $data = WashCategory::findOrFail($id);
        $record = $data->update([
                'wash_name'=> $wash_name,
                'wash_desc'=> $wash_desc,
                'cwo_id'=> $cwo_id,
                'price_sedan_hatchback'=> $price_sedan_hatchback,
                'price_suv_cab'=> $price_suv_cab,
                'price_van_mini'=> $price_van_mini,
                'price_tucks_busses'=> $price_tucks_busses,
                'is_active'=> $is_active,
                'updated_at'=>$dt->toDayDateTimeString()
            ]);
        /*update wash_categories table ends*/
        return back()->with('success', 'Wash Category has been updated successfully.')->with('msg_class', 'alert alert-success');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function delete($id){
        $record = WashCategory::findorfail($id); // fetch the record
        $record->is_active = "3";
        $record->save();
        return back()->with('msg', 'Wash Category has been deleted successfully.')
                ->with('msg_class', 'alert alert-success');
    }
}
