<x-app-layout>
    @section('page_css')
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/core/menu/menu-types/vertical-menu.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/core/colors/palette-gradient.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/plugins/forms/wizard.css') }}">


    @endsection
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">Add Banner</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ $home_url }}">Home</a></li>
                                    <li class="breadcrumb-item"><a href="{{ route('admin.cwo.list') }}">Cwo</a></li>
                                    <li class="breadcrumb-item"><a href="{{ route('admin.banner.list', $cwoid) }}">Banner</a></li>
                                    <li class="breadcrumb-item active">Create</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="content-body">
                <section id="validation">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                {{-- <div class="card-header">
                                    <h4 class="card-title">Validation Example</h4>
                                </div> --}}
                                <div class="card-content">
                                    <div class="card-body">
                                        @if ($errors->any())
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                        <form action="{{ route('admin.banner.store', $cwoid) }}"
                                            class="steps-validation wizard-circle" method="POST"
                                            enctype="multipart/form-data">
                                            @csrf
                                            <fieldset>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="banner_path">
                                                                Banner Image
                                                            </label>
                                                            <input type="file" class="form-control" id="banner_path" name="banner_path" placeholder="Banner Image">
                                                            <small class="form-text text-muted">For better result the size of the image would be width X height</small>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6 offset-md-4">

                                                        <button type="submit" class="btn btn-primary mr-1 mb-1">Save</button>

                                                        <a class="btn btn-outline-warning mr-1 mb-1" href="{{ route('admin.banner.list', $cwoid) }}">Back</a>

                                                    </div>

                                                </div>

                                                
                                            </fieldset>


                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>
    @section('page_scripts')
    <script src="{{ asset('app-assets/vendors/js/extensions/jquery.steps.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js')}}"></script>
    <script src="{{ asset('app-assets/js/scripts/forms/wizard-steps.js') }}"></script>
    <script>
        $(document).ready(function() {
            $("#logo-upload").on('change', function() {
                //Get count of selected files
                var countFiles = $(this)[0].files.length;
                var imgPath = $(this)[0].value;
                var extn = imgPath.substring(imgPath.lastIndexOf('.') + 1).toLowerCase();
                var image_holder = $(".logo-box");
                image_holder.empty();
                if (extn == "gif" || extn == "png" || extn == "jpg" || extn == "jpeg") {
                if (typeof(FileReader) != "undefined") {
                    //loop for each file selected for uploaded.
                    for (var i = 0; i < countFiles; i++) 
                    {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $("<img />", {
                        "src": e.target.result,
                        "class": "thumb-image"
                        }).appendTo(image_holder);
                    }
                    image_holder.show();
                    reader.readAsDataURL($(this)[0].files[i]);
                    }
                } else {
                    alert("This browser does not support FileReader.");
                }
                } else {
                alert("Pls select only images");
                }
            });
            $(".banner-img").on('change', function() {
                //Get count of selected files
                var countFiles = $(this)[0].files.length;
                var imgPath = $(this)[0].value;
                var extn = imgPath.substring(imgPath.lastIndexOf('.') + 1).toLowerCase();
                var image_holder = $(this).parents('.img-box-wrapper').find(".banner-box");
                image_holder.empty();
                if (extn == "gif" || extn == "png" || extn == "jpg" || extn == "jpeg") {
                if (typeof(FileReader) != "undefined") {
                    //loop for each file selected for uploaded.
                    for (var i = 0; i < countFiles; i++) 
                    {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $("<img />", {
                        "src": e.target.result,
                        "class": "thumb-image"
                        }).appendTo(image_holder);
                    }
                    image_holder.show();
                    reader.readAsDataURL($(this)[0].files[i]);
                    }
                } else {
                    alert("This browser does not support FileReader.");
                }
                } else {
                alert("Pls select only images");
                }
            });
        });
    </script>
    @endsection
</x-app-layout>