<x-app-layout>
    @section('page_css')
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/core/menu/menu-types/vertical-menu.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/core/colors/palette-gradient.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/plugins/forms/wizard.css') }}">


    @endsection
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">Edit Banner</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ $home_url }}">Home</a></li>
                                    <li class="breadcrumb-item"><a href="{{ route('admin.cwo.list') }}">Cwo</a></li>
                                    <li class="breadcrumb-item"><a href="{{ route('admin.banner.list', $cwoid) }}">Banner</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="content-body">
                <section id="validation">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                {{-- <div class="card-header">
                                    <h4 class="card-title">Validation Example</h4>
                                </div> --}}
                                <div class="card-content">
                                    <div class="card-body">
                                        @if ($errors->any())
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                        <form action="{{ route('admin.banner.update', array($cwoid, $details['id'])) }}"
                                            class="steps-validation wizard-circle" method="POST"
                                            enctype="multipart/form-data">
                                            @csrf
                                            <fieldset>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="banner_path">
                                                                Banner Image
                                                            </label>
                                                            <input type="file" class="form-control" id="banner_path" name="banner_path" placeholder="Banner Image">
                                                            <small class="form-text text-muted">For better result the size of the image would be width X height</small>
                                                <img src="{{ asset('images/banner/'.$details['banner_path']) }}" width="100" />
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6 offset-md-4">

                                                        <button type="submit" class="btn btn-primary mr-1 mb-1">Save</button>

                                                        <a class="btn btn-outline-warning mr-1 mb-1" href="{{ route('admin.banner.list', $cwoid) }}">Back</a>

                                                    </div>

                                                </div>

                                                
                                            </fieldset>


                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>
    @section('page_scripts')
    <script src="{{ asset('app-assets/vendors/js/extensions/jquery.steps.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js')}}"></script>
    <script src="{{ asset('app-assets/js/scripts/forms/wizard-steps.js') }}"></script>
    
    @endsection
</x-app-layout>