<x-app-layout>
    @section('page_css')
        <link rel="stylesheet" type="text/css"
            href="{{ asset('app-assets/vendors/css/tables/datatable/datatables.min.css') }}">
        <link rel="stylesheet" type="text/css"
            href="{{ asset('app-assets/vendors/css/tables/datatable/extensions/dataTables.checkboxes.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/pages/data-list-view.css') }}">
    @endsection
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-8 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">Search Cars</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ $home_url }}">Home</a></li>
                                    <li class="breadcrumb-item">Car Search</li>
                                    <li class="breadcrumb-item active">List</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="content-header-right text-md-right col-md-4 col-12 d-md-block d-none">
                    <div class="form-group breadcrum-right">
                        <div class="buttons-section">
                            @include('carsearch.partials._action_buttons')
                        </div>

                    </div>
                </div>

            </div>
            <div class="content-body">
                <section id="data-list-view" class="data-list-view-header">
                    @include('carsearch.partials._filter')

                    <!-- DataTable starts -->
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Sl No.</th>
                                    <!-- <th>Customer ID</th> -->
                                    <th>Registration No.</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Wash Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                    @foreach($records as $index =>$singleData)
                                    <tr style="background-color:#ffffff;">
                                        <td>{{$index + $records->firstItem()}}</td>
                                        <!-- <td></td> -->
                                        <td>{{$singleData['car_registration_no']}}</td>
                                        <td>{{$singleData['co_fname']}} {{$singleData['co_lname']}}</td>
                                        <td>{{$singleData['email']}}</td>
                                        <td>{{$singleData['co_phone']}}</td>
                                        <td>
                                            @if($singleData['date_washed'] != '')
                                                {{date("jS M Y", strtotime($singleData['date_washed']))}}
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            <!-- <tfoot>
                                <tr>
                                <th>Sl No.</th>
                                    <th>Registration No.</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Wash Date</th>
                                </tr>
                            </tfoot> -->

                        </table>
                    </div>
                    <!-- DataTable ends -->


                </section>

            </div>
        </div>
    </div>
    @section('page_scripts')
        <script src="{{ asset('app-assets/vendors/js/extensions/dropzone.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.buttons.min.js') }}"></script>
        {{-- <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js')}}"></script> --}}
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.select.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.checkboxes.min.js') }}"></script>

        <script>
            var _url = "{{ route('admin.cwo.fetch.list') }}";

            $(document).ready(function() {
                $('#download_csv').click(function() {
                    let url = $(this).data('url');
                    // var status = $("#status").val();
                    var search = $("input[type=search]").val();
                    debugger
                    var querystring = '?&search=' + search;
                    window.location = url + querystring;
                })
            });
        </script>
        <script src="{{ asset('app-assets/js/scripts/ui/data-list-view.js') }}"></script>
    @endsection

</x-app-layout>
