<x-app-layout>
    @section('page_css')
        <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/core/menu/menu-types/vertical-menu.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/core/colors/palette-gradient.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/plugins/forms/wizard.css') }}">
    @endsection
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">{{ $carowner_info->co_fname }}
                                {{ $carowner_info->co_lname }}'s Car</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a
                                            href="{{ isset($home_url) ? $home_url : '' }}">Home</a>
                                    </li>
                                    <li class="breadcrumb-item"><a
                                            href="{{ route('admin.coc.list', $carowner_info->id) }}">{{ $carowner_info->co_fname }}
                                            {{ $carowner_info->co_lname }}'s
                                            Car</a>
                                    </li>
                                    <li class="breadcrumb-item active">Create</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="content-body">
                <section id="validation">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                {{-- <div class="card-header">
                                    <h4 class="card-title">Validation Example</h4>
                                </div> --}}
                                <div class="card-content">
                                    <div class="card-body">
                                        @if ($errors->has('message'))
                                            <div class="alert alert-danger" role="alert">
                                                {{-- <h4 class="alert-heading">Danger</h4> --}}
                                                <p class="mb-0">
                                                    {{ $errors->first('message') }}
                                                </p>
                                            </div>
                                        @endif
                                        @if (Session::has('success'))
                                            <div class="alert alert-success" role="alert">
                                                {{-- <h4 class="alert-heading">Success</h4> --}}
                                                <p class="mb-0">
                                                    {{ Session::get('success') }}
                                                </p>
                                            </div>
                                        @endif
                                        <form action="{{ route('admin.coc.store', $carowner_info->id) }}"
                                            class="steps-validation wizard-circle" method="POST"
                                            enctype="multipart/form-data">
                                            @csrf

                                            <fieldset>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="car_model">
                                                                Car Model
                                                            </label>
                                                            <input type="text" class="form-control " id="car_model"
                                                                name="car_model" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="car_registration_no">
                                                                Car Registration No.
                                                            </label>
                                                            <input type="text" class="form-control "
                                                                id="car_registration_no" name="car_registration_no"
                                                                required>
                                                        </div>
                                                    </div>



                                                </div>


                                                <div class="row">

                                                    <div class="col-12">
                                                        <button type="submit"
                                                            class="btn btn-primary mr-1 mb-1">Submit</button>
                                                        <a href="{{ route('admin.cwc.list') }}">
                                                            <button type="button"
                                                                class="btn btn-outline-warning mr-1 mb-1">Back</button>
                                                        </a>
                                                    </div>
                                                </div>

                                            </fieldset>
                                            <!-- Step 1 -->
                                            {{-- @include('carwashowner.partials._step_1') --}}

                                            <!-- Step 2 -->
                                            {{-- @include('carwashowner.partials._step_2') --}}


                                            <!-- Step 3 -->
                                            {{-- @include('carwashowner.partials._step_3') --}}

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>
    @section('page_scripts')
        <script src="{{ asset('app-assets/vendors/js/extensions/jquery.steps.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js') }}"></script>
        <script>
            $(document).ready(function() {

                $(".steps-validation").validate({
                    ignore: 'input[type=hidden]', // ignore hidden fields
                    errorClass: 'danger',
                    successClass: 'success',
                    highlight: function(element, errorClass) {
                        $(element).removeClass(errorClass);
                    },
                    unhighlight: function(element, errorClass) {
                        $(element).removeClass(errorClass);
                    },
                    errorPlacement: function(error, element) {
                        error.insertAfter(element);
                    },
                    rules: {
                        co_email: {
                            email: true,
                            required: true
                        },
                        co_fname: "required",
                        co_lname: "required",
                        co_phone: "required",
                    }
                });

                $("#logo-upload").on('change', function() {
                    //Get count of selected files
                    var countFiles = $(this)[0].files.length;
                    var imgPath = $(this)[0].value;
                    var extn = imgPath.substring(imgPath.lastIndexOf('.') + 1).toLowerCase();
                    var image_holder = $(".logo-box");
                    image_holder.empty();
                    if (extn == "gif" || extn == "png" || extn == "jpg" || extn == "jpeg") {
                        if (typeof(FileReader) != "undefined") {
                            //loop for each file selected for uploaded.
                            for (var i = 0; i < countFiles; i++) {
                                var reader = new FileReader();
                                reader.onload = function(e) {
                                    $("<img />", {
                                        "src": e.target.result,
                                        "class": "thumb-image"
                                    }).appendTo(image_holder);
                                }
                                image_holder.show();
                                reader.readAsDataURL($(this)[0].files[i]);
                            }
                        } else {
                            alert("This browser does not support FileReader.");
                        }
                    } else {
                        alert("Pls select only images");
                    }
                });
                $(".banner-img").on('change', function() {
                    //Get count of selected files
                    var countFiles = $(this)[0].files.length;
                    var imgPath = $(this)[0].value;
                    var extn = imgPath.substring(imgPath.lastIndexOf('.') + 1).toLowerCase();
                    var image_holder = $(this).parents('.img-box-wrapper').find(".banner-box");
                    image_holder.empty();
                    if (extn == "gif" || extn == "png" || extn == "jpg" || extn == "jpeg") {
                        if (typeof(FileReader) != "undefined") {
                            //loop for each file selected for uploaded.
                            for (var i = 0; i < countFiles; i++) {
                                var reader = new FileReader();
                                reader.onload = function(e) {
                                    $("<img />", {
                                        "src": e.target.result,
                                        "class": "thumb-image"
                                    }).appendTo(image_holder);
                                }
                                image_holder.show();
                                reader.readAsDataURL($(this)[0].files[i]);
                            }
                        } else {
                            alert("This browser does not support FileReader.");
                        }
                    } else {
                        alert("Pls select only images");
                    }
                });
            });
        </script>
    @endsection
</x-app-layout>
