<x-app-layout>
    @section('page_css')
        <link rel="stylesheet" type="text/css"
            href="{{ asset('app-assets/vendors/css/tables/datatable/datatables.min.css') }}">
        <link rel="stylesheet" type="text/css"
            href="{{ asset('app-assets/vendors/css/tables/datatable/extensions/dataTables.checkboxes.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/pages/data-list-view.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/extensions/toastr.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/extensions/sweetalert2.min.css') }}">
    @endsection
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-8 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">Car Owners List</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ $home_url }}">Home</a></li>
                                    <li class="breadcrumb-item">Car Owners</li>
                                    <li class="breadcrumb-item active">List</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="content-header-right text-md-right col-md-4 col-12 d-md-block d-none">
                    <div class="form-group breadcrum-right">
                        <div class="buttons-section">
                            @include('carwashclient.partials._action_buttons')
                        </div>

                    </div>
                </div>

            </div>
            <div class="content-body">
                <section id="data-list-view" class="data-list-view-header">
                    {{-- @include('carwashowner.partials._filter') --}}

                    <!-- DataTable starts -->
                    <div class="table-responsive">
                        <table class="table data-list-view">
                            <thead>
                                <tr>
                                    <th>Sl</th>
                                    <th>Name</th>
                                    <th>Phone</th>
                                    <th>Email</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>Sl</th>
                                    <th>Name</th>
                                    <th>Phone</th>
                                    <th>Email</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>

                        </table>
                    </div>
                    <!-- DataTable ends -->


                </section>

            </div>
        </div>
    </div>
    @section('page_scripts')
        <script src="{{ asset('app-assets/vendors/js/extensions/dropzone.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.buttons.min.js') }}"></script>
        {{-- <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js')}}"></script> --}}
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.select.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.checkboxes.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/extensions/toastr.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/extensions/sweetalert2.all.min.js') }}"></script>

        <script>
            var _url = "{{ route('admin.cwc.fetch.list') }}";

            $(document).ready(function() {
                $('#download_csv').click(function() {
                    let url = $(this).data('url');
                    // var status = $("#status").val();
                    var search = $("input[type=search]").val();
                    debugger
                    var querystring = '?&search=' + search;
                    window.location = url + querystring;
                })

                $(document).on('change', ".change_status", function() {
                    let _id = $(this).data('id');
                    var is_active = $("#customSwitch_" + _id + "[type='checkbox']:checked").val();
                    let status = 0;
                    if ($.trim(is_active) == 'on') {
                        status = 1;

                    }
                    let _url = "{{ route('admin.cwc.status_change_ajax') }}";
                    var csrfToken = $('meta[name="csrf-token"]').attr('content');
                    let data = {
                        'id': _id,
                        'status': status,
                        _token: csrfToken,
                    };

                    $.post(_url, data, function(response) {
                        if (response.status == 1) {
                            toastr.success('Status changed successfully.', 'Success!');

                        } else {

                            toastr.error('Status Changed Failed.', 'Failed!');

                        }
                    })
                })

                $(document).on('click', ".delete_cwo", function() {
                    var _this = $(this);
                    var _id = $(this).data('id');
                    var _url = "{{ route('admin.cwc.delete') }}";
                    var data = {
                        'id': _id,
                    };
                    Swal.fire({
                        title: 'Do you want to delete this?',
                        type: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!',
                        confirmButtonClass: 'btn btn-primary',
                        cancelButtonClass: 'btn btn-danger ml-1',
                        buttonsStyling: false,
                    }).then(function(result) {



                        if (result.value) {
                            $.ajax({
                                url: _url,
                                type: 'POST',
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                data: data,
                                success: function(response) {
                                    if (response.status == 1) {
                                        toastr.success('User deleted.', 'Deleted!');
                                        _this.parents('tr').remove();
                                    } else {

                                        toastr.error('Something went wrong.', 'Failed!');

                                    }
                                }

                            });

                        }

                    })

                })
            });
        </script>
        <script src="{{ asset('app-assets/js/scripts/ui/data-list-view.js') }}"></script>
    @endsection

</x-app-layout>
