<x-app-layout>
    @section('page_css')
        <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/core/menu/menu-types/vertical-menu.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/core/colors/palette-gradient.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/plugins/forms/wizard.css') }}">
        <style type="text/css">
            


        </style>
    @endsection
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">Car Wash Owner Profile</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a
                                            href="{{ isset($home_url) ? $home_url : '' }}">Home</a>
                                    </li>
                                    <li class="breadcrumb-item"><a href="{{ route('admin.cwo.list') }}">Cwo</a></li>
                                    <li class="breadcrumb-item active">Create</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="content-body">
                <section id="validation">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                {{-- <div class="card-header">
                                    <h4 class="card-title">Validation Example</h4>
                                </div> --}}
                                <div class="card-content">
                                    <div class="card-body">
                                        @if ($errors->has('message'))
                                            <div class="alert alert-danger" role="alert">
                                                {{-- <h4 class="alert-heading">Danger</h4> --}}
                                                <p class="mb-0">
                                                    {{ $errors->first('message') }}
                                                </p>
                                            </div>
                                        @endif
                                        @if (Session::has('success'))
                                            <div class="alert alert-success" role="alert">
                                                {{-- <h4 class="alert-heading">Success</h4> --}}
                                                <p class="mb-0">
                                                    {{ Session::get('success') }}
                                                </p>
                                            </div>
                                        @endif
                                        <form action="{{ route('admin.cwo.store') }}"
                                            class="steps-validation wizard-circle" method="POST"
                                            enctype="multipart/form-data">
                                            @csrf

                                            <fieldset>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="firstName3">
                                                                CWO Name
                                                            </label>
                                                            <input type="text" class="form-control " id="firstName3"
                                                                name="cwo_name" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="email5">
                                                                CWO Email
                                                            </label>
                                                            <input type="email" class="form-control" id="email5"
                                                                name="cwo_email">
                                                        </div>
                                                    </div>


                                                </div>

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="location">
                                                                ISD Code
                                                            </label>
                                                            <input type="text" class="form-control " id="isd"
                                                                name="cwo_isd">


                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="phone3">
                                                                CWO Phone
                                                            </label>
                                                            <input type="tel" class="form-control " id="phone3"
                                                                name="cwo_phone">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="location">
                                                                Company
                                                            </label>
                                                            <input type="company" class="form-control " id="company5"
                                                                name="cwo_company">


                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="currency_id">
                                                                Currency
                                                            </label>
                                                            <select class="form-control" id="currency_id" name="currency_id">
                                                                <option value="">Please select a Currency</option>
                                                                @if(isset($currencies) && !empty($currencies) && count($currencies))
                                                                    @foreach($currencies as $c)
                                                                        <option value="{{$c['id']}}">{{$c['code']}} ({{$c['symbol']}})</option>
                                                                    @endforeach
                                                                @endif
                                                            </select>


                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="media">
                                                            <a href="javascript: void(0);">
                                                                <img src="{{ asset('app-assets/images/portrait/small/avatar.png') }}"
                                                                    class="rounded mr-75" alt="profile image"
                                                                    height="64" width="64">
                                                            </a>
                                                            <div class="media-body mt-75">
                                                                <div
                                                                    class="col-12 px-0 d-flex flex-sm-row flex-column justify-content-start">
                                                                    <label
                                                                        class="btn btn-sm btn-primary ml-50 mb-50 mb-sm-0 cursor-pointer waves-effect waves-light"
                                                                        for="account-upload">Upload logo</label>
                                                                    <input type="file" id="account-upload"
                                                                        hidden="" name="cwo_logo">
                                                                    {{-- <button
                                                                        class="btn btn-sm btn-outline-warning ml-50 waves-effect waves-light">Reset</button>
                                                                    --}}
                                                                </div>
                                                                <p class="text-muted ml-75 mt-50"><small>Allowed JPG,
                                                                        GIF or PNG.</small></p>
                                                            </div>
                                                        </div>
                                                        {{-- <div class="img-box-wrapper">
                                                            <div class="banner-box"></div>

                                                            <label
                                                                class="btn btn-sm btn-primary ml-50 mb-50 mb-sm-0 cursor-pointer waves-effect waves-light"
                                                                for="banner-upload1">
                                                                SELECT LOGO
                                                            </label>
                                                            <input type="file" id="banner-upload1" hidden=""
                                                                class="banner-img" name="banner[]">

                                                        </div> --}}
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-12">
                                                        <fieldset class="form-label-group">
                                                            <textarea class="form-control" name="cwo_business_details" id="label-textarea" rows="3"
                                                                placeholder="Business Description"></textarea>
                                                            <label for="label-textarea">Business Description</label>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="form-group">
                                                            <label for="address">
                                                                Address
                                                            </label>
                                                            <input type="text" class="form-control controls" id="pac-input" name="address" placeholder="Search Address">
                                                        </div>
                                                        <div class="form-group">
                                                            <div id="map"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">    
                                                    <div class="col-12">
                                                        <button type="submit"
                                                            class="btn btn-primary mr-1 mb-1">Submit</button>
                                                        <a href="{{ route('admin.cwo.list') }}">
                                                            <button type="button"
                                                                class="btn btn-outline-warning mr-1 mb-1">Back</button>
                                                        </a>
                                                    </div>
                                                </div>

                                            </fieldset>
                                            <!-- Step 1 -->
                                            {{-- @include('carwashowner.partials._step_1') --}}

                                            <!-- Step 2 -->
                                            {{-- @include('carwashowner.partials._step_2') --}}


                                            <!-- Step 3 -->
                                            {{-- @include('carwashowner.partials._step_3') --}}

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>
    @section('page_scripts')
        <script src="{{ asset('app-assets/vendors/js/extensions/jquery.steps.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js') }}"></script>
        <script src="{{ asset('app-assets/js/scripts/forms/wizard-steps.js') }}"></script>
        <script>
            $(document).ready(function() {

                $(".steps-validation").validate({
                    ignore: 'input[type=hidden]', // ignore hidden fields
                    errorClass: 'danger',
                    successClass: 'success',
                    highlight: function(element, errorClass) {
                        $(element).removeClass(errorClass);
                    },
                    unhighlight: function(element, errorClass) {
                        $(element).removeClass(errorClass);
                    },
                    errorPlacement: function(error, element) {
                        error.insertAfter(element);
                    },
                    rules: {
                        email: {
                            email: true,
                            required: true
                        },
                        firstName: "required",
                        isd: "required",
                        phone: "required",
                        company: "required",
                        currency_id: "required",
                        address: "required"
                    }
                });

                $("#logo-upload").on('change', function() {
                    //Get count of selected files
                    var countFiles = $(this)[0].files.length;
                    var imgPath = $(this)[0].value;
                    var extn = imgPath.substring(imgPath.lastIndexOf('.') + 1).toLowerCase();
                    var image_holder = $(".logo-box");
                    image_holder.empty();
                    if (extn == "gif" || extn == "png" || extn == "jpg" || extn == "jpeg") {
                        if (typeof(FileReader) != "undefined") {
                            //loop for each file selected for uploaded.
                            for (var i = 0; i < countFiles; i++) {
                                var reader = new FileReader();
                                reader.onload = function(e) {
                                    $("<img />", {
                                        "src": e.target.result,
                                        "class": "thumb-image"
                                    }).appendTo(image_holder);
                                }
                                image_holder.show();
                                reader.readAsDataURL($(this)[0].files[i]);
                            }
                        } else {
                            alert("This browser does not support FileReader.");
                        }
                    } else {
                        alert("Pls select only images");
                    }
                });
                $(".banner-img").on('change', function() {
                    //Get count of selected files
                    var countFiles = $(this)[0].files.length;
                    var imgPath = $(this)[0].value;
                    var extn = imgPath.substring(imgPath.lastIndexOf('.') + 1).toLowerCase();
                    var image_holder = $(this).parents('.img-box-wrapper').find(".banner-box");
                    image_holder.empty();
                    if (extn == "gif" || extn == "png" || extn == "jpg" || extn == "jpeg") {
                        if (typeof(FileReader) != "undefined") {
                            //loop for each file selected for uploaded.
                            for (var i = 0; i < countFiles; i++) {
                                var reader = new FileReader();
                                reader.onload = function(e) {
                                    $("<img />", {
                                        "src": e.target.result,
                                        "class": "thumb-image"
                                    }).appendTo(image_holder);
                                }
                                image_holder.show();
                                reader.readAsDataURL($(this)[0].files[i]);
                            }
                        } else {
                            alert("This browser does not support FileReader.");
                        }
                    } else {
                        alert("Pls select only images");
                    }
                });
            });
        </script>
    @endsection
</x-app-layout>
