<x-app-layout>
    @section('page_css')
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/datatables.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/extensions/dataTables.checkboxes.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/pages/data-list-view.css') }}">

    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-8 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">User List</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ $home_url }}">Home</a></li>
                                    <li class="breadcrumb-item"><a href="{{ route('admin.cwo.list') }}">Cwo</a></li>
                                    <li class="breadcrumb-item active">User List</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="content-header-right text-md-right col-md-4 col-12 d-md-block d-none">
                    <div class="form-group breadcrum-right">
                        <div class="buttons-section">
                            @include('cwouser.partials._action_buttons')
                        </div>

                    </div>
                </div>

            </div>
            <div class="content-body">
                <section id="data-list-view" class="data-list-view-header">
                    <!-- @include('cwouser.partials._filter') -->

                    <!-- filters start -->
                    <!-- <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Filters</h4>
                            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                            <div class="heading-elements">
                                <ul class="list-inline mb-0">
                                    <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                                    <li><a data-action=""><i class="feather icon-rotate-cw users-data-filter"></i></a>
                                    </li>
                                    <li><a data-action="close"><i class="feather icon-x"></i></a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="card-content collapse show">
                            <div class="card-body">
                                <div class="users-list-filter">
                                    <form>
                                        <div class="row">
                                            <div class="col-12 col-sm-6 col-lg-3">
                                                <label for="users-list-role">Role</label>
                                                <fieldset class="form-group">
                                                    <select class="form-control" id="users-list-role">
                                                        <option value="">All</option>
                                                        <option value="user">User</option>
                                                        <option value="staff">Staff</option>
                                                    </select>
                                                </fieldset>
                                            </div>
                                            <div class="col-12 col-sm-6 col-lg-3">
                                                <label for="users-list-status">Status</label>
                                                <fieldset class="form-group">
                                                    <select class="form-control" id="users-list-status">
                                                        <option value="">All</option>
                                                        <option value="Active">Active</option>
                                                        <option value="Blocked">Blocked</option>
                                                        <option value="deactivated">Deactivated</option>
                                                    </select>
                                                </fieldset>
                                            </div>
                                            <div class="col-12 col-sm-6 col-lg-3">
                                                <label for="users-list-verified">Verified</label>
                                                <fieldset class="form-group">
                                                    <select class="form-control" id="users-list-verified">
                                                        <option value="">All</option>
                                                        <option value="true">Yes</option>
                                                        <option value="false">No</option>
                                                    </select>
                                                </fieldset>
                                            </div>
                                            <div class="col-12 col-sm-6 col-lg-3">
                                                <label for="users-list-department">Department</label>
                                                <fieldset class="form-group">
                                                    <select class="form-control" id="users-list-department">
                                                        <option value="">All</option>
                                                        <option value="Sales">Sales</option>
                                                        <option value="Devlopment">Devlopment</option>
                                                        <option value="Management">Management</option>
                                                    </select>
                                                </fieldset>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div> -->
                    <!-- filters end -->

                    <!-- DataTable starts -->
                    <div class="table-responsive">
                        <?php $i=1; ?>
                        @if(isset($records) && !empty($records) && count($records))
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Sl No.</th>
                                        <th>User Name</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>User Type</th>
                                        <th>CWO</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($records as $index =>$singleData)
                                    <?php
                                    // print_r($singleData);exit;
                                    ?>
                                    <tr style="background-color:#ffffff;">
                                        <td>{{$index + $records->firstItem()}}</td>
                                        <td>{{$singleData['name']}}</td>
                                        <td>{{$singleData['email']}}</td>
                                        <td>{{$singleData['phone']}}</td>
                                        <td>CWO User</td>
                                        <td>{{$singleData['cwoDetail']['cwo_company']}}</td>
                                        <td>
                                                    <a title="Edit user" href="{{ route('admin.cu.user.edit', array($cwoid, $singleData['id'])) }}"><i class="feather icon-edit"></i></a>
                                                    <a title="Delete user" onclick="return confirm('Are you sure, are you delete this user?');" href="{{ route('admin.cu.user.delete', array('userid' => $singleData['id'])) }}" style="color: red;"><i class="feather icon-trash"></i></a>
                                                </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <!-- <tfoot>
                                    <tr>
                                    <th>Sl No.</th>
                                        <th>User Name</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>User Type</th>
                                        <th>CWO</th>
                                        <th>Action</th>
                                    </tr>
                                </tfoot> -->

                            </table>
                        @endif
                    </div>
                    <!-- DataTable ends -->

                    <div class="row">
                        <div class="col-12 col-sm-12">
                            <div class="float-right">
                                <!-- @if(isset($records) && count($records)) {{ $records->links('pagination::bootstrap-4') }} @endif -->
                                @if(isset($records) && count($records)) {{ $records->appends($_GET)->links('pagination::bootstrap-4') }} @endif
                            </div>
                        </div>
                    </div>


                </section>

            </div>
        </div>
    </div>
    @section('page_scripts')
    <script src="{{ asset('app-assets/vendors/js/extensions/dropzone.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.buttons.min.js')}}"></script>
    {{-- <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js')}}"></script> --}}
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.select.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.checkboxes.min.js')}}"></script>

    <script>
        var _url = "{{route('admin.cwo.fetch.list')}}";
       
        $(document).ready(function(){
            $('#download_csv').click(function(){
                let url = $(this).data('url');
                // var status = $("#status").val();
                var search = $("input[type=search]").val();
                debugger
                var querystring = '?&search=' + search;
                window.location= url+querystring;
            })
        });

       
    </script>
    <script src="{{ asset('app-assets/js/scripts/ui/data-list-view.js') }}"></script>

    @endsection

</x-app-layout>