<x-app-layout>
    @section('page_css')
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/core/menu/menu-types/vertical-menu.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/core/colors/palette-gradient.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/plugins/forms/wizard.css') }}">


    @endsection
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">Edit Unit</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ $home_url }}">Home</a></li>
                                    <li class="breadcrumb-item"><a href="{{ route('admin.cwo.list') }}">Cwo</a></li>
                                    <li class="breadcrumb-item"><a href="{{ route('admin.unit.list', $cwoid) }}">Unit</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="content-body">
                <section id="validation">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                {{-- <div class="card-header">
                                    <h4 class="card-title">Validation Example</h4>
                                </div> --}}
                                <div class="card-content">
                                    <div class="card-body">
                                        @if ($errors->any())
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                        @if (Session::has('success'))
                                        <div class="alert alert-success" role="alert">
                                            {{-- <h4 class="alert-heading">Success</h4> --}}
                                            <p class="mb-0">
                                                {{ Session::get('success') }}
                                            </p>
                                        </div>
                                        @endif
                                        <form action="{{ route('admin.unit.update', array($cwoid, $details['id'])) }}"
                                            class="steps-validation wizard-circle" method="POST"
                                            enctype="multipart/form-data">
                                            @csrf
                                            <fieldset>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="unit_name">
                                                                Unit Name
                                                            </label>
                                                            <input type="text" class="form-control " id="unit_name" name="unit_name" value="{{$details['unit_name']}}">
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="cwo_address">
                                                                Unit Address
                                                            </label>
                                                            <input type="text" class="form-control " id="cwo_address" name="cwo_address" value="{{$details['cwo_address']}}">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="unit_email">
                                                                Unit Email
                                                            </label>
                                                            <input type="text" class="form-control" id="unit_email" name="unit_email" value="{{$details['unit_email']}}">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="unit_phone">
                                                                Unit Phone
                                                            </label>
                                                            <input type="tel" class="form-control " id="unit_phone" name="unit_phone" value="{{$details['unit_phone']}}">


                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="unit_phone">
                                                                Status
                                                            </label>
                                                            <select name="is_active" class="form-control">
                                                                <option value="1" @if(isset($details) && $details['is_active'] == 1) selected="selected" @endif>Active</option>
                                                    <option value="0" @if(isset($details) && $details['is_active'] == 0) selected="selected" @endif>Inactive</option>
                                                            </select>


                                                        </div>
                                                    </div>

                                                    <div class="col-md-6 offset-md-4">

                                                        <button type="submit" class="btn btn-primary mr-1 mb-1">Save</button>

                                                        <a class="btn btn-outline-warning mr-1 mb-1" href="{{ route('admin.unit.list', $cwoid) }}">Back</a>

                                                    </div>

                                                </div>

                                                
                                            </fieldset>


                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>
    @section('page_scripts')
    <script src="{{ asset('app-assets/vendors/js/extensions/jquery.steps.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js')}}"></script>
    <script src="{{ asset('app-assets/js/scripts/forms/wizard-steps.js') }}"></script>
    
    @endsection
</x-app-layout>