<x-app-layout>
    @section('page_css')
        <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/core/menu/menu-types/vertical-menu.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/core/colors/palette-gradient.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/plugins/forms/wizard.css') }}">
    @endsection
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">Wash Category</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ $home_url }}">Home</a></li>
                                    <li class="breadcrumb-item"><a href="{{ route('admin.wc.list') }}">Wash Category</a>
                                    </li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="content-body">
                <section id="validation">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                {{-- <div class="card-header">
                                    <h4 class="card-title">Validation Example</h4>
                                </div> --}}
                                <div class="card-content">
                                    <div class="card-body">
                                        @if ($errors->any())
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                        @if (Session::has('success'))
                                        <div class="alert alert-success" role="alert">
                                            {{-- <h4 class="alert-heading">Success</h4> --}}
                                            <p class="mb-0">
                                                {{ Session::get('success') }}
                                            </p>
                                        </div>
                                        @endif
                                        <form action="{{ route('admin.wc.update', array('id' => $details['id'])) }}"
                                            class="steps-validation wizard-circle" method="POST"
                                            enctype="multipart/form-data">
                                            @csrf
                                            <!-- Step 1 -->
                                            <!-- @include('washcategory.partials._form') -->
                                            <fieldset>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="wash_name">
                                                                Wash Name
                                                            </label>
                                                            <input type="text" class="form-control " id="wash_name" name="wash_name" value="@if(isset($details)){{ $details['wash_name'] }}@endif">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="cwo_id">
                                                                Car Wash Owner Company
                                                            </label>
                                                            <select class="form-control" id="cwo_id" name="cwo_id">
                                                                <option value="">Please select a Car Wash Owner Company</option>
                                                                @if(isset($cwo) && !empty($cwo) && count($cwo))
                                                                    @foreach($cwo as $c)
                                                                        <!-- <option value="{{$c['id']}}">{{$c['cwo_company']}}</option> -->
                                                                        <option value="{{$c['id']}}" @if($details['cwo_id'] == $c['id']) selected="selected" @endif>{{$c['cwo_company']}}
                                                                            @if($c['currencyDetail']!= '') (currency - {{$c['currencyDetail']['symbol']}})
                                @endif
                                                                        </option>
                                                                    @endforeach
                                                                @endif
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <fieldset class="form-label-group">
                                                                <textarea class="form-control " id="wash_desc" name="wash_desc" rows="3" placeholder="Wash Description">@if(isset($details)){{ $details['wash_desc'] }}@endif</textarea>
                                                            </fieldset>    
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="price_sedan_hatchback">
                                                                Price sedan hatchback
                                                            </label>
                                                            <input type="text" class="form-control " id="price_sedan_hatchback" name="price_sedan_hatchback" value="@if(isset($details)){{ $details['price_sedan_hatchback'] }}@endif">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="price_suv_cab">
                                                                Price suv cab
                                                            </label>
                                                            <input type="text" class="form-control " id="price_suv_cab" name="price_suv_cab" value="@if(isset($details)){{ $details['price_suv_cab'] }}@endif">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="price_van_mini">
                                                                Price van mini
                                                            </label>
                                                            <input type="text" class="form-control " id="price_van_mini" name="price_van_mini" value="@if(isset($details)){{ $details['price_van_mini'] }}@endif">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="price_tucks_busses">
                                                                Price trucks busses
                                                            </label>
                                                            <input type="text" class="form-control " id="price_tucks_busses" name="price_tucks_busses" value="@if(isset($details)){{ $details['price_tucks_busses'] }}@endif">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="is_active">
                                                                Status
                                                            </label>
                                                            <select name="is_active" class="form-control">
                                                                <option value="1" @if(isset($details) && $details['is_active'] == 1) selected="selected" @endif>Active</option>
                                                    <option value="0" @if(isset($details) && $details['is_active'] == 0) selected="selected" @endif>Inactive</option>
                                                            </select>


                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 offset-md-4">
                                                        <button type="submit" class="btn btn-primary mr-1 mb-1">Save</button>
                                                        <a class="btn btn-outline-warning mr-1 mb-1" href="{{ route('admin.wc.list') }}">Back</a>
                                                    </div>
                                                </div>
                                            </fieldset>



                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>
    @section('page_scripts')
        <script src="{{ asset('app-assets/vendors/js/extensions/jquery.steps.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js') }}"></script>
        <script src="{{ asset('app-assets/js/scripts/forms/wizard-steps.js') }}"></script>
        <script>
            $(document).ready(function() {
                $("#logo-upload").on('change', function() {
                    //Get count of selected files
                    var countFiles = $(this)[0].files.length;
                    var imgPath = $(this)[0].value;
                    var extn = imgPath.substring(imgPath.lastIndexOf('.') + 1).toLowerCase();
                    var image_holder = $(".logo-box");
                    image_holder.empty();
                    if (extn == "gif" || extn == "png" || extn == "jpg" || extn == "jpeg") {
                        if (typeof(FileReader) != "undefined") {
                            //loop for each file selected for uploaded.
                            for (var i = 0; i < countFiles; i++) {
                                var reader = new FileReader();
                                reader.onload = function(e) {
                                    $("<img />", {
                                        "src": e.target.result,
                                        "class": "thumb-image"
                                    }).appendTo(image_holder);
                                }
                                image_holder.show();
                                reader.readAsDataURL($(this)[0].files[i]);
                            }
                        } else {
                            alert("This browser does not support FileReader.");
                        }
                    } else {
                        alert("Pls select only images");
                    }
                });
                $(".banner-img").on('change', function() {
                    //Get count of selected files
                    var countFiles = $(this)[0].files.length;
                    var imgPath = $(this)[0].value;
                    var extn = imgPath.substring(imgPath.lastIndexOf('.') + 1).toLowerCase();
                    var image_holder = $(this).parents('.img-box-wrapper').find(".banner-box");
                    image_holder.empty();
                    if (extn == "gif" || extn == "png" || extn == "jpg" || extn == "jpeg") {
                        if (typeof(FileReader) != "undefined") {
                            //loop for each file selected for uploaded.
                            for (var i = 0; i < countFiles; i++) {
                                var reader = new FileReader();
                                reader.onload = function(e) {
                                    $("<img />", {
                                        "src": e.target.result,
                                        "class": "thumb-image"
                                    }).appendTo(image_holder);
                                }
                                image_holder.show();
                                reader.readAsDataURL($(this)[0].files[i]);
                            }
                        } else {
                            alert("This browser does not support FileReader.");
                        }
                    } else {
                        alert("Pls select only images");
                    }
                });
            });
        </script>
    @endsection
</x-app-layout>
