<x-app-layout>
    @section('page_css')
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/datatables.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/extensions/dataTables.checkboxes.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/pages/data-list-view.css') }}">
    <style>
    </style>

    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-8 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">Wash Report</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ $home_url }}">Home</a></li>
                                    <li class="breadcrumb-item active">Wash Report</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="content-header-right text-md-right col-md-4 col-12 d-md-block d-none">
                    <div class="form-group breadcrum-right">
                        <div class="buttons-section">
                            @include('washreport.partials._action_buttons')
                        </div>

                    </div>
                </div>

            </div>
            <div class="content-body">
                <section id="data-list-view" class="data-list-view-header">

                    <!-- filters start -->
                    <!-- filters end -->

                    <!-- DataTable starts -->
                    <div class="table-responsive">
                        <?php $i=1; ?>
                        @if(isset($records) && !empty($records) && count($records))
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Sl No.</th>
                                        <th>CWO Name</th>
                                        <th>Client Name</th>
                                        <th>Client Email</th>
                                        <th>Client Phone</th>
                                        <th>Car Registration No.</th>
                                        <th>Body Type</th>
                                        <th>Car Wash Type</th>
                                        <th>Amount</th>
                                        <th>Date Time</th>
                                        <!-- <th>Time Washed</th> -->
                                        <th>Car Wash Status</th>
                                        <!-- <th>Payment Status</th> -->
                                        <th>Payment Type</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($records as $index =>$singleData)
                                    <tr style="background-color:#ffffff;">
                                        <td>{{$index + $records->firstItem()}}</td>
                                        <td>{{$singleData['cwo_name']}}</td>
                                        <td>{{$singleData['co_fname']}} {{$singleData['co_lname']}}</td>
                                        <td>{{$singleData['email']}}</td>
                                        <td>{{$singleData['co_phone']}}</td>
                                        <td>{{$singleData['car_registration_no']}}</td>
                                        <td>{{$singleData['body_type']}}</td>
                                        <td>{{$singleData['wash_name']}}</td>
                                        <td>{{$singleData['symbol']}}{{$singleData['amount']}}</td>
                                        <td>
                                            @if($singleData['date_washed'] != '')
                                                {{date("d-m-Y", strtotime($singleData['date_washed']))}}
                                            @endif
                                            @if($singleData['time_washed'] != '')
                                                {{date("h:i a", strtotime($singleData['time_washed']))}}
                                            @endif
                                        </td>
                                        <!-- <td>
                                            @if($singleData['time_washed'] != '')
                                                {{date("h:i a", strtotime($singleData['time_washed']))}}
                                            @endif
                                        </td> -->
                                        <td>
                                            @if($singleData['status'] == 1)
                                                Completed
                                            @else
                                                Pending
                                            @endif
                                        </td>
                                        <!-- <td>
                                            @if($singleData['payment_status'] == 1)
                                                Completed
                                            @else
                                                Pending
                                            @endif
                                        </td> -->
                                        <td>{{$singleData['payment_details']}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <!-- <tfoot>
                                    <tr>
                                        <th>Sl No.</th>
                                        <th>CWO Name</th>
                                        <th>Client Name</th>
                                        <th>Client Email</th>
                                        <th>Client Phone</th>
                                        <th>Car Registration No.</th>
                                        <th>Body Type</th>
                                        <th>Car Wash Type</th>
                                        <th>Amount</th>
                                        <th>Date Washed</th>
                                        <th>Time Washed</th>
                                        <th>Car Wash Status</th>
                                        <th>Payment Status</th>
                                        <th>Payment Type</th>
                                    </tr>
                                </tfoot> -->

                            </table>
                        @endif
                    </div>
                    <!-- DataTable ends -->

                    <div class="row">
                        <div class="col-12 col-sm-12">
                            <div class="float-right">
                                <!-- @if(isset($records) && count($records)) {{ $records->links('pagination::bootstrap-4') }} @endif -->
                                @if(isset($records) && count($records)) {{ $records->appends($_GET)->links('pagination::bootstrap-4') }} @endif
                            </div>
                        </div>
                    </div>


                </section>

            </div>
        </div>
    </div>
    @section('page_scripts')
    <script src="{{ asset('app-assets/vendors/js/extensions/dropzone.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.buttons.min.js')}}"></script>
    {{-- <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js')}}"></script> --}}
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.select.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.checkboxes.min.js')}}"></script>

    <!-- <script>
        var _url = "{{route('admin.cwo.fetch.list')}}";
       
        $(document).ready(function(){
            $('#download_csv').click(function(){
                let url = $(this).data('url');
                // var status = $("#status").val();
                var search = $("input[type=search]").val();
                debugger
                var querystring = '?&search=' + search;
                window.location= url+querystring;
            })
        });

       
    </script> -->
    <script src="{{ asset('app-assets/js/scripts/ui/data-list-view.js') }}"></script>

    @endsection

</x-app-layout>